/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize

uniform int depth;

/////////////////////////////////////////////////////////////////////////////////

const int numBlobs = 32;

const vec3 k1 = vec3(0.100,0.010,0.001);
const vec3 k2 = vec3(0.4,0.2,0.3);
const vec3 k3 = vec3(0.0,0.0,0.4);

void main( void )
 {
   vec2 p = gl_FragCoord.xy - 0.5*resolution;
   p = p / max (  resolution.x, resolution.y );

   vec3 c = vec3(0.0);
   vec3 t = vec3(0.5,0.4,0.3)*time;

   for ( int i=0; i<numBlobs; i++ )
    {
      float i1 = float(i);
      float i2 = i1 * i1;
      float i3 = i2 * i1;
      float i4 = i2 * i2;
      float i5 = i3 * i2;

      vec3 q = vec3(i1,i2,i3);
      q = sin(q*k1+t);

      if ( (depth==1) ^^ (q.z > 0.0) ) 
       { 
         q = q*k2 + k3;

         float r = 0.002 / q.z;
         float z = r - length(p+q.xy);
     
         if ( z > 0.0 ) 
          { c +=  ( sin(vec3(i3,i5,i4)) + 1.0 ) * 0.5 * z / r;
          }

       }

    }

   c = c +vec3(p.y);
   gl_FragColor = vec4 ( c, length(c) );

}